// Validación + reCAPTCHA + anti-spam básico (cooldown)
document.addEventListener('DOMContentLoaded', () => {
  const form    = document.getElementById('contact-form');
  if(!form) return;

  const maxChars = 500;
  const message  = form.querySelector('#message');
  const count    = form.querySelector('#count');
  const success  = form.querySelector('.form-success');
  const sendBtn  = document.getElementById('sendBtn');
  const captchaError = document.getElementById('captcha-error');

  // contador de caracteres
  const updateCount = () => {
    const len = message.value.length;
    if (len > maxChars) message.value = message.value.slice(0, maxChars);
    count.textContent = `${Math.min(len, maxChars)}/${maxChars}`;
  };
  message.addEventListener('input', updateCount);
  updateCount();

  const setError = (input, msg) => {
    const small = input.closest('.field')?.querySelector('.error');
    if (small) small.textContent = msg || '';
    if (msg) input.classList.add('is-error'); else input.classList.remove('is-error');
  };

  // Cooldown tras envío (evita reenvíos seguidos)
  const startCooldown = (sec=15) => {
    let rest = sec;
    sendBtn.disabled = true;
    const base = sendBtn.textContent;
    const t = setInterval(()=>{
      rest--;
      sendBtn.textContent = `${base} (${rest}s)`;
      if (rest <= 0){
        clearInterval(t);
        sendBtn.disabled = false;
        sendBtn.textContent = base;
      }
    }, 1000);
  };

  form.addEventListener('submit', (e) => {
    let ok = true;
    success.hidden = true;
    captchaError.textContent = '';

    // Honeypot
    if (form.website && form.website.value.trim() !== '') {
      e.preventDefault(); // bot
      return;
    }

    const fullName = form.fullName;
    const email    = form.email;
    const phone    = form.phone;

    if (!fullName.value.trim()) { setError(fullName, 'Ingresa tu nombre'); ok = false; } else setError(fullName, '');
    if (!email.value.match(/^[^\s@]+@[^\s@]+\.[^\s@]+$/)) { setError(email, 'Correo inválido'); ok = false; } else setError(email, '');
    if (!phone.value.trim()) { setError(phone, 'Ingresa tu teléfono'); ok = false; } else setError(phone, '');

    // reCAPTCHA v2
    const hasCaptcha = typeof grecaptcha !== 'undefined';
    if (hasCaptcha){
      const token = grecaptcha.getResponse();
      if (!token) {
        ok = false;
        captchaError.textContent = 'Confirma que no eres un robot.';
      }
    }

    if (!ok) {
      e.preventDefault();
      return;
    }

    // DEMO: si no hay backend, mostramos éxito local y aplicamos cooldown
    if (form.getAttribute('action') === '#') {
      e.preventDefault();
      form.reset();
      updateCount();
      if (hasCaptcha) grecaptcha.reset();
      success.hidden = false;
      success.scrollIntoView({behavior:'smooth', block:'center'});
      startCooldown(15);
    }
  });
});
