/* ================================
   EDITA AQUÍ: solo cursos y categorías
   - Agrega o quita objetos en cada categoría.
   - "orden" controla el orden. Si no lo pones, va al final.
   - Con "oculto:true" lo dejas cargado pero no visible.
=================================== */
// Formación en Robótica
const DATA = {
  ciber: [
    { id:'blue', orden:1, titulo:'DobotStudio', meta:'Inicial • Aún por definir',
      img:'../assets/imgs/DobotStudio.png',
      hero:'../assets/imgs/dobot1.png',
      desc:'Curso introductorio al software DobotStudio para la programación y simulación de brazos robóticos.',
      badges:['Robótica','Simulación','Control'],
      duracion:'Aún por definir', modalidad:'Virtual',
      requisitos:'Básicos de informática', link:'/pages/contacto.html',
      pdf:'/assets/docs/dobot.pdf'
    },
    { id:'red', orden:2, titulo:'El Internet de las Cosas (IoT)', meta:'Intermedio • Aún por definir',
      img:'../assets/imgs/IOT.png',
      hero:'../assets/imgs/iotcosas.png',
      desc:'Fundamentos y aplicaciones del Internet de las Cosas en entornos domésticos e industriales.',
      badges:['IoT','Sensores','Conectividad'],
      duracion:'Aún por definir', modalidad:'Virtual',
      requisitos:'Conocimientos básicos de redes y programación', link:'/pages/contacto.html',
      pdf:'/assets/docs/iot.pdf'
    },
    { id:'forense', orden:3, titulo:'Sensores con Microcontroladores', meta:'Intermedio • Aún por definir',
      img:'../assets/imgs/sensores y microcontroladores.png',
      hero:'../assets/imgs/arduino.png',
      desc:'Uso de microcontroladores para leer y procesar datos de sensores en proyectos prácticos.',
      badges:['Sensores','Microcontroladores','Electrónica'],
      duracion:'Aún por definir', modalidad:'Virtual',
      requisitos:'Conocimientos básicos de electrónica', link:'/pages/contacto.html',
      pdf:'/assets/docs/Sensores.pdf'
    },
    { id:'grc', orden:4, titulo:'SolidWorks', meta:'Inicial • Aún por definir',
      img:'../assets/imgs/Soliwortd.png',
      hero:'../assets/imgs/diseñosoli.png',
      desc:'Introducción al diseño 3D y modelado de piezas mecánicas utilizando SolidWorks.',
      badges:['CAD','Diseño 3D','Prototipado'],
      duracion:'Aún por definir', modalidad:'Virtual',
      requisitos:'No excluyentes', link:'/pages/contacto.html',
      pdf:'/assets/docs/SolidWorks.pdf'
    }
  ],
  // Redes y Telecomunicaciones
  redes: [
    { id:'ccna', orden:1, titulo:'HCIA Cloud Service', meta:'Inicial • Aún por definir',
      img:'../assets/imgs/Cloud.png',
      hero:'../assets/imgs/Cloud.png',
      desc:'Fundamentos de servicios en la nube de Huawei y gestión de recursos en la nube.',
      badges:['Huawei','Cloud','Servicios'],
      duracion:'Aún por definir', modalidad:'Virtual',
      requisitos:'Básicos de TI', link:'/pages/contacto.html',
      pdf:'/assets/docs/Cloud.pdf'
    },
    { id:'wifi', orden:2, titulo:'HCIA WLAN - Huawei', meta:'Intermedio • Aún por definir',
      img:'../assets/imgs/WLAN.png',
      hero:'../assets/imgs/WLAN.png',
      desc:'Diseño, despliegue y seguridad de redes inalámbricas empresariales.',
      badges:['WLAN','Seguridad','Site Survey'],
      duracion:'Aún por definir', modalidad:'Virtual',
      requisitos:'Conocimientos básicos de redes', link:'/pages/contacto.html',
      pdf:'/assets/docs/WLAN.pdf'
    },
    { id:'mik', orden:3, titulo:'HCIA-Datacom', meta:'Intermedio • Aún por definir',
      img:'../assets/imgs/Datacom.png',
      hero:'../assets/imgs/Datacom.png',
      desc:'Servicios y fundamentos de routing, switching y administración de redes de datos.',
      badges:['Routing','Switching','QoS'],
      duracion:'Aún por definir', modalidad:'Virtual',
      requisitos:'Conceptos básicos de redes', link:'/pages/contacto.html',
      pdf:'/assets/docs/Datacom.pdf'
    },
    { id:'linux', orden:4, titulo:'CCNA 1, 2 y 3', meta:'Inicial • Aún por definir',
      img:'../assets/imgs/ccna.png',
      hero:'../assets/imgs/ccna1.png',
      desc:'Fundamentos de redes y configuración en equipos Cisco a nivel CCNA.',
      badges:['Cisco','Redes','Switching'],
      duracion:'Aún por definir', modalidad:'Virtual',
      requisitos:'Básicos de redes', link:'/pages/contacto.html',
      pdf:'/assets/docs/CCNA.pdf'
    }
  ],
  // Seguridad en Redes
  cloud: [
    { id:'aws', orden:1, titulo:'Cisco-Network Security', meta:'Inicial • Aún por definir',
      img:'../assets/imgs/segurity.png',
      hero:'../assets/imgs/segurity.png',
      desc:'Conceptos y configuraciones de seguridad en redes Cisco.',
      badges:['Cisco','Seguridad','Redes'],
      duracion:'Aún por definir', modalidad:'Virtual',
      requisitos:'No excluyentes', link:'/pages/contacto.html',
      pdf:'/assets/docs/Cisco.pdf'
    },
    { id:'azure', orden:2, titulo:'Fortinet NSE4', meta:'Inicial • Aún por definir',
      img:'../assets/imgs/Forti.png',
      hero:'../assets/imgs/FortiGate.png',
      desc:'Configuración y administración de seguridad en dispositivos Fortinet.',
      badges:['Fortinet','Firewall','Seguridad'],
      duracion:'Aún por definir', modalidad:'Virtual',
      requisitos:'No excluyentes', link:'/pages/contacto.html',
      pdf:'/assets/docs/FortiGate.pdf'
    },
    {
      id: 'gcp', orden: 3, titulo: 'Odoo', meta: 'Intermedio • ERP Empresarial',
      img: '../assets/imgs/odoo.png',
      hero: '../assets/imgs/odoo.png',
      desc: 'Capacitación en instalación, configuración y personalización de Odoo para la gestión integral de empresas: ventas, inventario, contabilidad y recursos humanos.',
      badges: ['ERP', 'Gestión Empresarial', 'Automatización'],
      duracion: 'Aún por definir', modalidad: 'Virtual',
      requisitos: 'Conocimientos básicos de administración o informática', link: '/pages/contacto.html'
    },
    { id:'devops', orden:4, titulo:'Accesos', meta:'Intermedio • Aún por definir',
      img:'../assets/imgs/accesos.png',
      hero:'../assets/imgs/accesos.png',
      desc:'Gestión de accesos y autenticación segura en redes empresariales.',
      badges:['Accesos','Autenticación','Seguridad'],
      duracion:'Aún por definir', modalidad:'Virtual',
      requisitos:'Linux básico', link:'/pages/contacto.html'
    }
  ],
  // Otros
  auto: [
    { id:'python', orden:1, titulo:'Automatización con Python', meta:'Inicial • Aún por definir',
      img:'../assets/imgs/python.png',
      hero:'../assets/imgs/python.png',
      desc:'Automatiza tareas, procesos y flujos de trabajo con Python.',
      badges:['Python','Scripts','Automatización'],
      duracion:'Aún por definir', modalidad:'Virtual',
      requisitos:'Lógica básica', link:'/pages/contacto.html'
    },
    { id:'ansible', orden:2, titulo:'Infra como Código con Ansible', meta:'Intermedio • Aún por definir',
      img:'../assets/imgs/infra.png',
      hero:'../assets/imgs/infra.png',
      desc:'Gestión de infraestructura mediante código usando Ansible.',
      badges:['IaC','Ansible','Automatización'],
      duracion:'Aún por definir', modalidad:'Virtual',
      requisitos:'Linux básico', link:'/pages/contacto.html'
    },
    { id:'shell', orden:3, titulo:'Bash & PowerShell', meta:'Inicial • Aún por definir',
      img:'../assets/imgs/bash.png',
      hero:'../assets/imgs/bash.png',
      desc:'Uso de Bash y PowerShell para automatización de tareas en Linux y Windows.',
      badges:['Bash','PowerShell','CLI'],
      duracion:'Aún por definir', modalidad:'Virtual',
      requisitos:'Básicos de SO', link:'/pages/contacto.html'
    },
    { id:'rpa', orden:4, titulo:'RPA: Automatización de Procesos', meta:'Intermedio • Aún por definir',
      img:'../assets/imgs/RPA.png',
      hero:'../assets/imgs/RPA.png',
      desc:'Introducción a la automatización robótica de procesos (RPA) aplicada a organizaciones.',
      badges:['RPA','Procesos','Automatización'],
      duracion:'Aún por definir', modalidad:'Virtual',
      requisitos:'No excluyentes', link:'/pages/contacto.html'
    }
  ]
};

/* ======== NADA QUE EDITAR ABAJO ======== */
const catNav = document.querySelector('.cat-nav');
const grid   = document.querySelector('.curso-grid');
const detalle= document.getElementById('detalle-curso');

// Genera botones de categorías según DATA
const catKeys = Object.keys(DATA);
catNav.innerHTML = catKeys.map((k,i)=>(`
  <button class="cat-btn ${i===0?'is-active':''}" data-cat="${k}">${niceName(k)}</button>
`)).join('');

// Render inicial (primera categoría)
renderCategoria(catKeys[0]);

// Eventos categorías
catNav.addEventListener('click', (e)=>{
  const btn = e.target.closest('.cat-btn'); if(!btn) return;
  catNav.querySelectorAll('.cat-btn').forEach(b=>b.classList.remove('is-active'));
  btn.classList.add('is-active');
  renderCategoria(btn.dataset.cat);
});

// Click en curso -> Detalle
grid.addEventListener('click', (e)=>{
  const cardBtn = e.target.closest('button[data-cat][data-id]'); if(!cardBtn) return;
  const {cat, id} = cardBtn.dataset;
  const item = (DATA[cat]||[]).find(x=>x.id===id);
  if(item) renderDetalle(item);
});

// Helpers
function niceName(key){
  return {ciber:'Formación en Robótica', redes:'Redes y Telecomunicaciones', cloud:'Seguridad en Redes', auto:'Otros'}[key] || key;
}

function renderCategoria(catKey){
  const items = (DATA[catKey]||[])
    .filter(x=>!x.oculto)
    .sort((a,b)=> (a.orden??999) - (b.orden??999));

  grid.innerHTML = items.map(it => cardHTML(catKey, it)).join('');
  detalle.innerHTML = `<div class="detalle-empty"><p>Elige un curso para ver su plan, duración y modalidad.</p></div>`;
}

function cardHTML(cat, it){
  return `
  <article class="curso-card">
    <button data-cat="${cat}" data-id="${it.id}">
      <div class="curso-media">
        <img src="${it.img}" alt="${it.titulo}">
      </div>
      <div class="curso-body">
        <h3 class="curso-title">${it.titulo}</h3>
        <p class="curso-meta">${it.meta}</p>
      </div>
    </button>
  </article>`;
}

function renderDetalle(it){
  const pdfURL = it.pdf || '/assets/docs/informacion-curso.pdf';
  const waText = encodeURIComponent(`Hola, quiero inscribirme al curso "${it.titulo}".`);
  const waURL  = `https://wa.me/+59172694010?text=${waText}`;

  detalle.innerHTML = `
  <div class="detalle-wrap">
    <div class="detalle-media"><img src="${it.hero}" alt="${it.titulo}"></div>
    <div class="detalle-txt">
      <h2>${it.titulo}</h2>
      <div class="badges">${(it.badges||[]).map(b=>`<span class="badge">${b}</span>`).join('')}</div>
      <dl class="kv">
        <dt>Duración:</dt><dd>${it.duracion||'-'}</dd>
        <dt>Modalidad:</dt><dd>${it.modalidad||'-'}</dd>
        <dt>Requisitos:</dt><dd>${it.requisitos||'-'}</dd>
      </dl>
      <p>${it.desc||''}</p>
      <div class="actions">
        <a class="btn btn-primary" href="${it.link||'/pages/contacto.html'}">Inscribirme</a>
        <a class="btn btn-ghost" href="${pdfURL}" target="_blank" rel="noopener">Solicitar información (PDF)</a>
        <a class="btn btn-ghost" href="${waURL}" target="_blank" rel="noopener">Inscribirme por WhatsApp</a>
      </div>
    </div>
  </div>`;

  // Scroll formal al detalle
  autoScrollToDetalle();
}

/* ==========================
   SCROLL “FORMAL” AL DETALLE
   - En móvil (<=768px): siempre desplaza al bloque de detalle.
   - En desktop: solo si el detalle quedó fuera de vista.
========================== */
function autoScrollToDetalle(){
  if (!detalle) return;

  const isMobile = window.matchMedia('(max-width: 768px)').matches;
  const needsScrollDesktop = () => {
    const rect = detalle.getBoundingClientRect();
    return rect.top > 120 || rect.bottom > (window.innerHeight - 40);
  };

  if (isMobile || needsScrollDesktop()) {
    const offset = getHeaderOffset() + 10;
    requestAnimationFrame(()=>{
      const top = detalle.getBoundingClientRect().top + window.scrollY - offset;
      window.scrollTo({ top, behavior: 'smooth' });
      detalle.setAttribute('tabindex', '-1');
      detalle.focus({ preventScroll: true });
    });
  }
}

function getHeaderOffset(){
  const header = document.querySelector('.msa-header');
  if (!header) return 0;
  const styles = getComputedStyle(header);
  const marginBottom = parseFloat(styles.marginBottom || '0');
  return header.getBoundingClientRect().height + marginBottom;
}
