// js/header.js
document.addEventListener('click', e=>{
  const burger = e.target.closest('.msa-burger');
  const header = document.querySelector('.msa-header');
  if (burger && header) {
    const open = header.classList.toggle('open');
    burger.setAttribute('aria-expanded', open ? 'true' : 'false');
  }
});

// Sombra algo más marcada al hacer scroll (look enterprise)
document.addEventListener('scroll', ()=>{
  const h = document.querySelector('.msa-header');
  if(!h) return;
  const sc = window.scrollY || document.documentElement.scrollTop;
  h.style.boxShadow = sc > 6
    ? '0 8px 24px rgba(0,0,0,.14)'
    : '0 4px 16px rgba(0,0,0,.12)';
});
