// js/include.js
document.addEventListener('DOMContentLoaded', async () => {
  const slots = document.querySelectorAll('[data-include]');
  for (const el of slots) {
    const url = el.getAttribute('data-include');
    try {
      const res = await fetch(url);
      if (!res.ok) throw new Error('No se pudo cargar: ' + url);
      const html = await res.text();
      el.outerHTML = html;
    } catch (err) {
      console.error(err);
    }
  }
});
