// Animación reveal al hacer scroll
document.addEventListener('DOMContentLoaded', ()=>{
  const obs = new IntersectionObserver((entries)=>{
    entries.forEach(e=>{
      if(e.isIntersecting){
        e.target.classList.add('is-visible');
        obs.unobserve(e.target);
      }
    });
  }, {threshold: .15});
  document.querySelectorAll('.reveal').forEach(el=>obs.observe(el));
});

// Acordeón formal (una ventana abierta a la vez)
document.addEventListener('DOMContentLoaded', () => {
  const wins = document.querySelectorAll('[data-win]');
  wins.forEach(win => {
    const head = win.querySelector('.win-head');
    const body = win.querySelector('.win-body');
    const toggle = win.querySelector('.win-toggle');

    // estado inicial
    win.removeAttribute('open');
    body.hidden = true;
    toggle.setAttribute('aria-expanded', 'false');

    head.addEventListener('click', () => {
      const isOpen = win.hasAttribute('open');

      // cerrar otros
      document.querySelectorAll('[data-win][open]').forEach(w => {
        if (w !== win) {
          w.removeAttribute('open');
          const b = w.querySelector('.win-body');
          const t = w.querySelector('.win-toggle');
          if (b) b.hidden = true;
          if (t) t.setAttribute('aria-expanded', 'false');
        }
      });

      // toggle actual
      if (isOpen) {
        win.removeAttribute('open');
        body.hidden = true;
        toggle.setAttribute('aria-expanded', 'false');
      } else {
        win.setAttribute('open', '');
        body.hidden = false;
        toggle.setAttribute('aria-expanded', 'true');
        win.scrollIntoView({ behavior: 'smooth', block: 'nearest' });
      }
    });
  });
});
