// js/set-active.js
(function () {
  // Normaliza rutas: quita ?query, #hash, //, /index.html y barras finales (salvo '/')
  const norm = (p) => {
    let out = p.replace(/[?#].*$/,'').replace(/\/{2,}/g,'/').replace(/\/index\.html?$/i,'/');
    if (out.length > 1) out = out.replace(/\/+$/,'');
    return out || '/';
  };

  const applyActive = () => {
    const links = [...document.querySelectorAll('.msa-nav a, nav a.pill, .barra-navegacion a')];
    if (!links.length) return false;

    const current = norm(new URL(location.href).pathname);

    // Limpia cualquier resto previo
    links.forEach(a => {
      a.classList.remove('is-active','activo');
      a.removeAttribute('aria-current');
    });

    // Selección: exacto > prefijo más largo
    let best = null;
    for (const a of links) {
      const href = a.getAttribute('href');
      if (!href) continue;
      const path = norm(new URL(href, location.origin).pathname);

      let score = 0;
      if (path === current) score = 10000;                                // match exacto
      else if (path !== '/' && (current + '/').startsWith(path + '/'))    // prefijo
        score = path.length;

      if (score > 0 && (!best || score > best.score)) best = { el:a, score };
    }

    // Aplica activo (o home como fallback)
    const target = best?.el || links.find(a => norm(new URL(a.getAttribute('href')||'/', location.origin).pathname) === '/');
    if (target) {
      target.classList.add('is-active');
      target.setAttribute('aria-current','page'); // accesibilidad
    }
    return true;
  };

  // 1) Intenta ahora
  if (applyActive()) return;

  // 2) Si el header se inyecta después, observa el DOM y aplica una sola vez
  const mo = new MutationObserver(() => {
    if (applyActive()) mo.disconnect();
  });
  mo.observe(document.documentElement, { childList: true, subtree: true });

})();
