// js/set-active.js (versión robusta)
document.addEventListener('DOMContentLoaded', () => {
  const navLinks = Array.from(document.querySelectorAll('.msa-nav a, nav .pill, .barra-navegacion a'));
  if (!navLinks.length) return;

  const norm = (p) => {
    // Acepta path tipo '/', '/pages/cursos.html', 'cursos.html', etc.
    // 1) Quitar query/hash  2) colapsar //  3) quitar /index.html  4) quitar / final excepto raíz
    let out = p.replace(/[?#].*$/, '');
    out = out.replace(/\/{2,}/g, '/');
    out = out.replace(/\/index\.html?$/i, '/');
    if (out.length > 1) out = out.replace(/\/+$/, '');
    return out || '/';
  };

  // Ruta actual normalizada
  const current = norm(new URL(location.href).pathname);

  // Calcular mejor coincidencia (exacta > prefijo más largo)
  let best = null; // {el, score}
  navLinks.forEach((a) => {
    // Normaliza href como URL absoluta y toma el pathname
    const href = a.getAttribute('href') || '';
    if (!href) return;

    const linkPath = norm(new URL(href, location.origin).pathname);

    // Puntuación:
    // 10000 si es igual; si no, prefijo válido (current empieza con linkPath + '/')
    let score = 0;
    if (linkPath === current) {
      score = 10000; // exact match
    } else if (
      linkPath !== '/' &&
      (current + '/').startsWith(linkPath + '/')
    ) {
      score = linkPath.length; // cuanto más largo, más específico
    }

    if (score > 0 && (!best || score > best.score)) {
      best = { el: a, score };
    }
  });

  // Limpiar y aplicar al ganador solamente
  navLinks.forEach(a => a.classList.remove('is-active', 'activo'));
  if (best && best.el) {
    best.el.classList.add('is-active'); // tu CSS usa .is-active
  } else {
    // Fallback: si estamos en raíz y hay un link a '/', márcalo
    const home = navLinks.find(a => norm(new URL(a.getAttribute('href') || '/', location.origin).pathname) === '/');
    if (home) home.classList.add('is-active');
  }
});
